"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub, ctx, source: Dict, sinks: List = None, location: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates mappings.

    Args:
        source(Dict): Specifies the source table.
        sinks(List, optional): A list of target tables. Defaults to None.
        location(Dict, optional): Parameters for the mapping. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.mapping.get(ctx, source=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.mapping.get source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_mapping",
        op_kwargs={"Source": source, "Sinks": sinks, "Location": location},
    )
