"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def get(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all current job definitions.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum size of the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.jobs.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.jobs.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_jobs",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def list_(
    hub, ctx, next_token: str = None, max_results: int = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the names of all job resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names. This operation takes the optional Tags field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation request. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.
        tags(Dict, optional): Specifies to return only these tagged resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_jobs",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results, "Tags": tags},
    )
