"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, job_name: str, run_id: str, predecessors_included: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the metadata for a given job run.

    Args:
        job_name(str): Name of the job definition being run.
        run_id(str): The ID of the job run.
        predecessors_included(bool, optional): True if a list of predecessor runs should be returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.run.get(ctx, job_name=value, run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.run.get job_name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_job_run",
        op_kwargs={
            "JobName": job_name,
            "RunId": run_id,
            "PredecessorsIncluded": predecessors_included,
        },
    )


async def get_all(
    hub, ctx, job_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata for all runs of a given job definition.

    Args:
        job_name(str): The name of the job definition for which to retrieve all job runs.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum size of the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.run.get_all(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.run.get_all job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_job_runs",
        op_kwargs={
            "JobName": job_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    job_name: str,
    job_run_id: str = None,
    arguments: Dict = None,
    allocated_capacity: int = None,
    timeout: int = None,
    max_capacity: float = None,
    security_configuration: str = None,
    notification_property: Dict = None,
    worker_type: str = None,
    number_of_workers: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a job run using a job definition.

    Args:
        job_name(str): The name of the job definition to use.
        job_run_id(str, optional): The ID of a previous JobRun to retry. Defaults to None.
        arguments(Dict, optional): The job arguments specifically for this run. For this job run, they replace the default arguments set in the job definition itself. You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue itself consumes. For information about how to specify and consume your own Job arguments, see the Calling Glue APIs in Python topic in the developer guide. For information about the key-value pairs that Glue consumes to set up your job, see the Special Parameters Used by Glue topic in the developer guide. Defaults to None.
        allocated_capacity(int, optional): This field is deprecated. Use MaxCapacity instead. The number of Glue data processing units (DPUs) to allocate to this JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page. Defaults to None.
        timeout(int, optional): The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job. Defaults to None.
        max_capacity(float, optional): The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page. Do not set Max Capacity if using WorkerType and NumberOfWorkers. The value that can be allocated for MaxCapacity depends on whether you are running a Python shell job, or an Apache Spark ETL job:   When you specify a Python shell job (JobCommand.Name="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.   When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.  . Defaults to None.
        security_configuration(str, optional): The name of the SecurityConfiguration structure to be used with this job run. Defaults to None.
        notification_property(Dict, optional): Specifies configuration properties of a job run notification. Defaults to None.
        worker_type(str, optional): The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.   For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.   For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.   For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.  . Defaults to None.
        number_of_workers(int, optional): The number of workers of a defined workerType that are allocated when a job runs. The maximum number of workers you can define are 299 for G.1X, and 149 for G.2X. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.run.start(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.run.start job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="start_job_run",
        op_kwargs={
            "JobName": job_name,
            "JobRunId": job_run_id,
            "Arguments": arguments,
            "AllocatedCapacity": allocated_capacity,
            "Timeout": timeout,
            "MaxCapacity": max_capacity,
            "SecurityConfiguration": security_configuration,
            "NotificationProperty": notification_property,
            "WorkerType": worker_type,
            "NumberOfWorkers": number_of_workers,
        },
    )
