"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    role: str,
    command: Dict,
    description: str = None,
    log_uri: str = None,
    execution_property: Dict = None,
    default_arguments: Dict = None,
    non_overridable_arguments: Dict = None,
    connections: Dict = None,
    max_retries: int = None,
    allocated_capacity: int = None,
    timeout: int = None,
    max_capacity: float = None,
    security_configuration: str = None,
    tags: Dict = None,
    notification_property: Dict = None,
    glue_version: str = None,
    number_of_workers: int = None,
    worker_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new job definition.

    Args:
        name(str): The name you assign to this job definition. It must be unique in your account.
        description(str, optional): Description of the job being defined. Defaults to None.
        log_uri(str, optional): This field is reserved for future use. Defaults to None.
        role(str): The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
        execution_property(Dict, optional): An ExecutionProperty specifying the maximum number of concurrent runs allowed for this job. Defaults to None.
        command(Dict): The JobCommand that runs this job.
        default_arguments(Dict, optional): The default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that Glue itself consumes. For information about how to specify and consume your own Job arguments, see the Calling Glue APIs in Python topic in the developer guide. For information about the key-value pairs that Glue consumes to set up your job, see the Special Parameters Used by Glue topic in the developer guide. Defaults to None.
        non_overridable_arguments(Dict, optional): Non-overridable arguments for this job, specified as name-value pairs. Defaults to None.
        connections(Dict, optional): The connections used for this job. Defaults to None.
        max_retries(int, optional): The maximum number of times to retry this job if it fails. Defaults to None.
        allocated_capacity(int, optional): This parameter is deprecated. Use MaxCapacity instead. The number of Glue data processing units (DPUs) to allocate to this Job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page. Defaults to None.
        timeout(int, optional): The job timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). Defaults to None.
        max_capacity(float, optional): For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page. Do not set Max Capacity if using WorkerType and NumberOfWorkers. The value that can be allocated for MaxCapacity depends on whether you are running a Python shell job or an Apache Spark ETL job:   When you specify a Python shell job (JobCommand.Name="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.   When you specify an Apache Spark ETL job (JobCommand.Name="glueetl") or Apache Spark streaming ETL job (JobCommand.Name="gluestreaming"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.   For Glue version 2.0 jobs, you cannot instead specify a Maximum capacity. Instead, you should specify a Worker type and the Number of workers. Defaults to None.
        security_configuration(str, optional): The name of the SecurityConfiguration structure to be used with this job. Defaults to None.
        tags(Dict, optional): The tags to use with this job. You may use tags to limit access to the job. For more information about tags in Glue, see Amazon Web Services Tags in Glue in the developer guide. Defaults to None.
        notification_property(Dict, optional): Specifies configuration properties of a job notification. Defaults to None.
        glue_version(str, optional): Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark.  For more information about the available Glue versions and corresponding Spark and Python versions, see Glue version in the developer guide. Jobs that are created without specifying a Glue version default to Glue 0.9. Defaults to None.
        number_of_workers(int, optional): The number of workers of a defined workerType that are allocated when a job runs. The maximum number of workers you can define are 299 for G.1X, and 149 for G.2X. . Defaults to None.
        worker_type(str, optional): The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.   For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.   For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.   For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.init.create(ctx, name=value, role=value, command=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.init.create name=value, role=value, command=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_job",
        op_kwargs={
            "Name": name,
            "Description": description,
            "LogUri": log_uri,
            "Role": role,
            "ExecutionProperty": execution_property,
            "Command": command,
            "DefaultArguments": default_arguments,
            "NonOverridableArguments": non_overridable_arguments,
            "Connections": connections,
            "MaxRetries": max_retries,
            "AllocatedCapacity": allocated_capacity,
            "Timeout": timeout,
            "MaxCapacity": max_capacity,
            "SecurityConfiguration": security_configuration,
            "Tags": tags,
            "NotificationProperty": notification_property,
            "GlueVersion": glue_version,
            "NumberOfWorkers": number_of_workers,
            "WorkerType": worker_type,
        },
    )


async def delete(hub, ctx, job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified job definition. If the job definition is not found, no exception is thrown.

    Args:
        job_name(str): The name of the job definition to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.init.delete(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.init.delete job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_job",
        op_kwargs={"JobName": job_name},
    )


async def get(hub, ctx, job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an existing job definition.

    Args:
        job_name(str): The name of the job definition to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.init.get(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.init.get job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="get_job", op_kwargs={"JobName": job_name}
    )


async def update(hub, ctx, job_name: str, job_update: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing job definition.

    Args:
        job_name(str): The name of the job definition to update.
        job_update(Dict): Specifies the values with which to update the job definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.init.update(ctx, job_name=value, job_update=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.init.update job_name=value, job_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_job",
        op_kwargs={"JobName": job_name, "JobUpdate": job_update},
    )
