"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, job_name: str, run_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information on a job bookmark entry.

    Args:
        job_name(str): The name of the job in question.
        run_id(str, optional): The unique run identifier associated with this job run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.bookmark.get(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.bookmark.get job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_job_bookmark",
        op_kwargs={"JobName": job_name, "RunId": run_id},
    )


async def reset(hub, ctx, job_name: str, run_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Resets a bookmark entry.

    Args:
        job_name(str): The name of the job in question.
        run_id(str, optional): The unique run identifier associated with this job run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.job.bookmark.reset(ctx, job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.job.bookmark.reset job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="reset_job_bookmark",
        op_kwargs={"JobName": job_name, "RunId": run_id},
    )
