"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, names: List, include_graph: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resource metadata for a given list of workflow names. After calling the ListWorkflows operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.

    Args:
        names(List): A list of workflow names, which may be the names returned from the ListWorkflows operation.
        include_graph(bool, optional): Specifies whether to include a graph when returning the workflow resource metadata. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.workflow.batch(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.workflow.batch names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_workflows",
        op_kwargs={"Names": names, "IncludeGraph": include_graph},
    )
