"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, trigger_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resource metadata for a given list of trigger names. After calling the ListTriggers operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.

    Args:
        trigger_names(List): A list of trigger names, which may be the names returned from the ListTriggers operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.trigger.batch(ctx, trigger_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.trigger.batch trigger_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_triggers",
        op_kwargs={"TriggerNames": trigger_names},
    )
