"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partitions_to_get: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves partitions in a batch request.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partitions reside.
        table_name(str): The name of the partitions' table.
        partitions_to_get(List): A list of partition values identifying the partitions to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.partition.batch(
                ctx, database_name=value, table_name=value, partitions_to_get=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.partition.batch database_name=value, table_name=value, partitions_to_get=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionsToGet": partitions_to_get,
        },
    )
