"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, job_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resource metadata for a given list of job names. After calling the ListJobs operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.

    Args:
        job_names(List): A list of job names, which might be the names returned from the ListJobs operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.job.batch(ctx, job_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.job.batch job_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_jobs",
        op_kwargs={"JobNames": job_names},
    )
