"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, dev_endpoint_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resource metadata for a given list of development endpoint names. After calling the ListDevEndpoints operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.

    Args:
        dev_endpoint_names(List): The list of DevEndpoint names, which might be the names returned from the ListDevEndpoint operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.dev_endpoint.batch(ctx, dev_endpoint_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.dev_endpoint.batch dev_endpoint_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_dev_endpoints",
        op_kwargs={"DevEndpointNames": dev_endpoint_names},
    )
