"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, crawler_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resource metadata for a given list of crawler names. After calling the ListCrawlers operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.

    Args:
        crawler_names(List): A list of crawler names, which might be the names returned from the ListCrawlers operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.get.crawler.batch(ctx, crawler_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.get.crawler.batch crawler_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_get_crawlers",
        op_kwargs={"CrawlerNames": crawler_names},
    )
