"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, transform_id: str, output_s3_path: str) -> Dict:
    r"""
    **Autogenerated function**

    Begins an asynchronous task to export all labeled data for a particular transform. This task is the only label-related API call that is not part of the typical active learning workflow. You typically use StartExportLabelsTaskRun when you want to work with all of your existing labels at the same time, such as when you want to remove or change labels that were previously submitted as truth. This API operation accepts the TransformId whose labels you want to export and an Amazon Simple Storage Service (Amazon S3) path to export the labels to. The operation returns a TaskRunId. You can check on the status of your task run by calling the GetMLTaskRun API.

    Args:
        transform_id(str): The unique identifier of the machine learning transform.
        output_s3_path(str): The Amazon S3 path where you export the labels.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.export_label_task_run.start(
                ctx, transform_id=value, output_s3_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.export_label_task_run.start transform_id=value, output_s3_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="start_export_labels_task_run",
        op_kwargs={"TransformId": transform_id, "OutputS3Path": output_s3_path},
    )
