"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    endpoint_name: str,
    role_arn: str,
    security_group_ids: List = None,
    subnet_id: str = None,
    public_key: str = None,
    public_keys: List = None,
    number_of_nodes: int = None,
    worker_type: str = None,
    glue_version: str = None,
    number_of_workers: int = None,
    extra_python_libs_s3_path: str = None,
    extra_jars_s3_path: str = None,
    security_configuration: str = None,
    tags: Dict = None,
    arguments: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new development endpoint.

    Args:
        endpoint_name(str): The name to be assigned to the new DevEndpoint.
        role_arn(str): The IAM role for the DevEndpoint.
        security_group_ids(List, optional): Security group IDs for the security groups to be used by the new DevEndpoint. Defaults to None.
        subnet_id(str, optional): The subnet ID for the new DevEndpoint to use. Defaults to None.
        public_key(str, optional): The public key to be used by this DevEndpoint for authentication. This attribute is provided for backward compatibility because the recommended attribute to use is public keys. Defaults to None.
        public_keys(List, optional): A list of public keys to be used by the development endpoints for authentication. The use of this attribute is preferred over a single public key because the public keys allow you to have a different private key per client.  If you previously created an endpoint with a public key, you must remove that key to be able to set a list of public keys. Call the UpdateDevEndpoint API with the public key content in the deletePublicKeys attribute, and the list of new keys in the addPublicKeys attribute. . Defaults to None.
        number_of_nodes(int, optional): The number of Glue Data Processing Units (DPUs) to allocate to this DevEndpoint. Defaults to None.
        worker_type(str, optional): The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.   For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.   For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.   For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.   Known issue: when a development endpoint is created with the G.2X WorkerType configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. . Defaults to None.
        glue_version(str, optional): Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints.  For more information about the available Glue versions and corresponding Spark and Python versions, see Glue version in the developer guide. Development endpoints that are created without specifying a Glue version default to Glue 0.9. You can specify a version of Python support for development endpoints by using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint APIs. If no arguments are provided, the version defaults to Python 2. Defaults to None.
        number_of_workers(int, optional): The number of workers of a defined workerType that are allocated to the development endpoint. The maximum number of workers you can define are 299 for G.1X, and 149 for G.2X. . Defaults to None.
        extra_python_libs_s3_path(str, optional): The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your DevEndpoint. Multiple values must be complete paths separated by a comma.  You can only use pure Python libraries with a DevEndpoint. Libraries that rely on C extensions, such as the pandas Python data analysis library, are not yet supported. . Defaults to None.
        extra_jars_s3_path(str, optional): The path to one or more Java .jar files in an S3 bucket that should be loaded in your DevEndpoint. Defaults to None.
        security_configuration(str, optional): The name of the SecurityConfiguration structure to be used with this DevEndpoint. Defaults to None.
        tags(Dict, optional): The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more information about tags in Glue, see Amazon Web Services Tags in Glue in the developer guide. Defaults to None.
        arguments(Dict, optional): A map of arguments used to configure the DevEndpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.create(
                ctx, endpoint_name=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.create endpoint_name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_dev_endpoint",
        op_kwargs={
            "EndpointName": endpoint_name,
            "RoleArn": role_arn,
            "SecurityGroupIds": security_group_ids,
            "SubnetId": subnet_id,
            "PublicKey": public_key,
            "PublicKeys": public_keys,
            "NumberOfNodes": number_of_nodes,
            "WorkerType": worker_type,
            "GlueVersion": glue_version,
            "NumberOfWorkers": number_of_workers,
            "ExtraPythonLibsS3Path": extra_python_libs_s3_path,
            "ExtraJarsS3Path": extra_jars_s3_path,
            "SecurityConfiguration": security_configuration,
            "Tags": tags,
            "Arguments": arguments,
        },
    )


async def delete(hub, ctx, endpoint_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified development endpoint.

    Args:
        endpoint_name(str): The name of the DevEndpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.delete(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.delete endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_dev_endpoint",
        op_kwargs={"EndpointName": endpoint_name},
    )


async def get(hub, ctx, endpoint_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a specified development endpoint.  When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address, and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns only a public IP address.

    Args:
        endpoint_name(str): Name of the DevEndpoint to retrieve information for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.get(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.get endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_dev_endpoint",
        op_kwargs={"EndpointName": endpoint_name},
    )


async def get_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all the development endpoints in this AWS account.  When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns only a public IP address.

    Args:
        max_results(int, optional): The maximum size of information to return. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_dev_endpoints",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the names of all DevEndpoint resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names. This operation takes the optional Tags field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation request. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.
        tags(Dict, optional): Specifies to return only these tagged resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_dev_endpoints",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results, "Tags": tags},
    )


async def update(
    hub,
    ctx,
    endpoint_name: str,
    public_key: str = None,
    add_public_keys: List = None,
    delete_public_keys: List = None,
    custom_libraries: Dict = None,
    update_etl_libraries: bool = None,
    delete_arguments: List = None,
    add_arguments: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specified development endpoint.

    Args:
        endpoint_name(str): The name of the DevEndpoint to be updated.
        public_key(str, optional): The public key for the DevEndpoint to use. Defaults to None.
        add_public_keys(List, optional): The list of public keys for the DevEndpoint to use. Defaults to None.
        delete_public_keys(List, optional): The list of public keys to be deleted from the DevEndpoint. Defaults to None.
        custom_libraries(Dict, optional): Custom Python or Java libraries to be loaded in the DevEndpoint. Defaults to None.
        update_etl_libraries(bool, optional):  True if the list of custom libraries to be loaded in the development endpoint needs to be updated, or False if otherwise. Defaults to None.
        delete_arguments(List, optional): The list of argument keys to be deleted from the map of arguments used to configure the DevEndpoint. Defaults to None.
        add_arguments(Dict, optional): The map of arguments to add the map of arguments used to configure the DevEndpoint. Valid arguments are:    "--enable-glue-datacatalog": ""    You can specify a version of Python support for development endpoints by using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint APIs. If no arguments are provided, the version defaults to Python 2. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dev_endpoint.update(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dev_endpoint.update endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_dev_endpoint",
        op_kwargs={
            "EndpointName": endpoint_name,
            "PublicKey": public_key,
            "AddPublicKeys": add_public_keys,
            "DeletePublicKeys": delete_public_keys,
            "CustomLibraries": custom_libraries,
            "UpdateEtlLibraries": update_etl_libraries,
            "DeleteArguments": delete_arguments,
            "AddArguments": add_arguments,
        },
    )
