"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    version_ids: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified batch of versions of a table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.
        table_name(str): The name of the table. For Hive compatibility, this name is entirely lowercase.
        version_ids(List): A list of the IDs of versions to be deleted. A VersionId is a string representation of an integer. Each version is incremented by 1.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.delete.table.version.batch(
                ctx, database_name=value, table_name=value, version_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.delete.table.version.batch database_name=value, table_name=value, version_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_delete_table_version",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "VersionIds": version_ids,
        },
    )
