"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, database_name: str, tables_to_delete: List, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes multiple tables at once.  After completing this operation, you no longer have access to the table versions and partitions that belong to the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service. To ensure the immediate deletion of all related resources, before calling BatchDeleteTable, use DeleteTableVersion or BatchDeleteTableVersion, and DeletePartition or BatchDeletePartition, to delete any resources that belong to the table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the tables to delete reside. For Hive compatibility, this name is entirely lowercase.
        tables_to_delete(List): A list of the table to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.delete.table.init.batch(
                ctx, database_name=value, tables_to_delete=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.delete.table.init.batch database_name=value, tables_to_delete=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_delete_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TablesToDelete": tables_to_delete,
        },
    )
