"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partitions_to_delete: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more partitions in a batch operation.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the table in question resides.
        table_name(str): The name of the table that contains the partitions to be deleted.
        partitions_to_delete(List): A list of PartitionInput structures that define the partitions to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.delete.partition.batch(
                ctx, database_name=value, table_name=value, partitions_to_delete=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.delete.partition.batch database_name=value, table_name=value, partitions_to_delete=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_delete_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionsToDelete": partitions_to_delete,
        },
    )
