"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, connection_name_list: List, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a list of connection definitions from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        connection_name_list(List): A list of names of the connections to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.delete.connection.batch(ctx, connection_name_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.delete.connection.batch connection_name_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_delete_connection",
        op_kwargs={"CatalogId": catalog_id, "ConnectionNameList": connection_name_list},
    )
