"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, python_script: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Transforms a Python script into a directed acyclic graph (DAG).

    Args:
        python_script(str, optional): The Python script to transform. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.dataflow_graph.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.dataflow_graph.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_dataflow_graph",
        op_kwargs={"PythonScript": python_script},
    )
