"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, database_input: Dict, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new database in a Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which to create the database. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_input(Dict): The metadata for the database.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.database.create(ctx, database_input=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.database.create database_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_database",
        op_kwargs={"CatalogId": catalog_id, "DatabaseInput": database_input},
    )


async def delete(hub, ctx, name: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes a specified database from a Data Catalog.  After completing this operation, you no longer have access to the tables (and all table versions and partitions that might belong to the tables) and the user-defined functions in the deleted database. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service. To ensure the immediate deletion of all related resources, before calling DeleteDatabase, use DeleteTableVersion or BatchDeleteTableVersion, DeletePartition or BatchDeletePartition, DeleteUserDefinedFunction, and DeleteTable or BatchDeleteTable, to delete any resources that belong to the database.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        name(str): The name of the database to delete. For Hive compatibility, this must be all lowercase.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.database.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.database.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_database",
        op_kwargs={"CatalogId": catalog_id, "Name": name},
    )


async def get(hub, ctx, name: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the definition of a specified database.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        name(str): The name of the database to retrieve. For Hive compatibility, this should be all lowercase.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.database.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.database.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_database",
        op_kwargs={"CatalogId": catalog_id, "Name": name},
    )


async def get_all(
    hub,
    ctx,
    catalog_id: str = None,
    next_token: str = None,
    max_results: int = None,
    resource_share_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all databases defined in a given Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog from which to retrieve Databases. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum number of databases to return in one response. Defaults to None.
        resource_share_type(str, optional): Allows you to specify that you want to list the databases shared with your account. The allowable values are FOREIGN or ALL.    If set to FOREIGN, will list the databases shared with your account.    If set to ALL, will list the databases shared with your account, as well as the databases in yor local account.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.database.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.database.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_databases",
        op_kwargs={
            "CatalogId": catalog_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ResourceShareType": resource_share_type,
        },
    )


async def update(
    hub, ctx, name: str, database_input: Dict, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing database definition in a Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the metadata database resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        name(str): The name of the database to update in the catalog. For Hive compatibility, this is folded to lowercase.
        database_input(Dict): A DatabaseInput object specifying the new definition of the metadata database in the catalog.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.database.update(ctx, name=value, database_input=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.database.update name=value, database_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_database",
        op_kwargs={
            "CatalogId": catalog_id,
            "Name": name,
            "DatabaseInput": database_input,
        },
    )
