"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the security configuration for a specified catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog to retrieve the security configuration for. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.data.catalog_encryption_setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.data.catalog_encryption_setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_data_catalog_encryption_settings",
        op_kwargs={"CatalogId": catalog_id},
    )


async def put_multiple(
    hub, ctx, data_catalog_encryption_settings: Dict, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the security configuration for a specified catalog. After the configuration has been set, the specified encryption is applied to every catalog write thereafter.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog to set the security configuration for. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        data_catalog_encryption_settings(Dict): The security configuration to set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.data.catalog_encryption_setting.put_multiple(
                ctx, data_catalog_encryption_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.data.catalog_encryption_setting.put_multiple data_catalog_encryption_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="put_data_catalog_encryption_settings",
        op_kwargs={
            "CatalogId": catalog_id,
            "DataCatalogEncryptionSettings": data_catalog_encryption_settings,
        },
    )
