"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_input_list: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more partitions in a batch operation.

    Args:
        catalog_id(str, optional): The ID of the catalog in which the partition is to be created. Currently, this should be the Amazon Web Services account ID. Defaults to None.
        database_name(str): The name of the metadata database in which the partition is to be created.
        table_name(str): The name of the metadata table in which the partition is to be created.
        partition_input_list(List): A list of PartitionInput structures that define the partitions to be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.create_partition.batch(
                ctx, database_name=value, table_name=value, partition_input_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.create_partition.batch database_name=value, table_name=value, partition_input_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_create_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionInputList": partition_input_list,
        },
    )
