"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, crawler_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Changes the schedule state of the specified crawler to SCHEDULED, unless the crawler is already running or the schedule state is already SCHEDULED.

    Args:
        crawler_name(str): Name of the crawler to schedule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.crawler.schedule.start(ctx, crawler_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.crawler.schedule.start crawler_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="start_crawler_schedule",
        op_kwargs={"CrawlerName": crawler_name},
    )


async def stop(hub, ctx, crawler_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the schedule state of the specified crawler to NOT_SCHEDULED, but does not stop the crawler if it is already running.

    Args:
        crawler_name(str): Name of the crawler whose schedule state to set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.crawler.schedule.stop(ctx, crawler_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.crawler.schedule.stop crawler_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="stop_crawler_schedule",
        op_kwargs={"CrawlerName": crawler_name},
    )


async def update(hub, ctx, crawler_name: str, schedule: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the schedule of a crawler using a cron expression.

    Args:
        crawler_name(str): The name of the crawler whose schedule to update.
        schedule(str, optional): The updated cron expression used to specify the schedule (see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, you would specify: cron(15 12 * * ? *). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.crawler.schedule.update(ctx, crawler_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.crawler.schedule.update crawler_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_crawler_schedule",
        op_kwargs={"CrawlerName": crawler_name, "Schedule": schedule},
    )
