"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    crawler_name_list: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metrics about specified crawlers.

    Args:
        crawler_name_list(List, optional): A list of the names of crawlers about which to retrieve metrics. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.crawler.metric.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.crawler.metric.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_crawler_metrics",
        op_kwargs={
            "CrawlerNameList": crawler_name_list,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
