"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, connection_input: Dict, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection definition in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which to create the connection. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        connection_input(Dict): A ConnectionInput object defining the connection to create.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.connection.create(ctx, connection_input=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.connection.create connection_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_connection",
        op_kwargs={"CatalogId": catalog_id, "ConnectionInput": connection_input},
    )


async def delete(hub, ctx, connection_name: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a connection from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        connection_name(str): The name of the connection to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.connection.delete(ctx, connection_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.connection.delete connection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_connection",
        op_kwargs={"CatalogId": catalog_id, "ConnectionName": connection_name},
    )


async def get(
    hub, ctx, name: str, catalog_id: str = None, hide_password: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a connection definition from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        name(str): The name of the connection definition to retrieve.
        hide_password(bool, optional): Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller might not have permission to use the KMS key to decrypt the password, but it does have permission to access the rest of the connection properties. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.connection.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.connection.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_connection",
        op_kwargs={
            "CatalogId": catalog_id,
            "Name": name,
            "HidePassword": hide_password,
        },
    )


async def get_all(
    hub,
    ctx,
    catalog_id: str = None,
    filter_: Dict = None,
    hide_password: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of connection definitions from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        filter_(Dict, optional): A filter that controls which connections are returned. Defaults to None.
        hide_password(bool, optional): Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller might not have permission to use the KMS key to decrypt the password, but it does have permission to access the rest of the connection properties. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum number of connections to return in one response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.connection.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.connection.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_connections",
        op_kwargs={
            "CatalogId": catalog_id,
            "Filter": filter_,
            "HidePassword": hide_password,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, name: str, connection_input: Dict, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a connection definition in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        name(str): The name of the connection definition to update.
        connection_input(Dict): A ConnectionInput object that redefines the connection in question.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.connection.update(ctx, name=value, connection_input=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.connection.update name=value, connection_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_connection",
        op_kwargs={
            "CatalogId": catalog_id,
            "Name": name,
            "ConnectionInput": connection_input,
        },
    )
