"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    column_name: str,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves table statistics of columns. The Identity and Access Management (IAM) permission required for this operation is DeleteTable.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partitions reside.
        table_name(str): The name of the partitions' table.
        column_name(str): The name of the column.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.column_statistic_for_.table.delete(
                ctx, database_name=value, table_name=value, column_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.column_statistic_for_.table.delete database_name=value, table_name=value, column_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_column_statistics_for_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "ColumnName": column_name,
        },
    )


async def get(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    column_names: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves table statistics of columns. The Identity and Access Management (IAM) permission required for this operation is GetTable.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partitions reside.
        table_name(str): The name of the partitions' table.
        column_names(List): A list of the column names.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.column_statistic_for_.table.get(
                ctx, database_name=value, table_name=value, column_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.column_statistic_for_.table.get database_name=value, table_name=value, column_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_column_statistics_for_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "ColumnNames": column_names,
        },
    )


async def update(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    column_statistics_list: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates table statistics of columns. The Identity and Access Management (IAM) permission required for this operation is UpdateTable.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partitions reside.
        table_name(str): The name of the partitions' table.
        column_statistics_list(List): A list of the column statistics.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.column_statistic_for_.table.update(
                ctx, database_name=value, table_name=value, column_statistics_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.column_statistic_for_.table.update database_name=value, table_name=value, column_statistics_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_column_statistics_for_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "ColumnStatisticsList": column_statistics_list,
        },
    )
