"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def import_(hub, ctx, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Imports an existing Amazon Athena Data Catalog to Glue.

    Args:
        catalog_id(str, optional): The ID of the catalog to import. Currently, this should be the Amazon Web Services account ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.catalog.to_glue.import(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.catalog.to_glue.import
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="import_catalog_to_glue",
        op_kwargs={"CatalogId": catalog_id},
    )
