"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the status of a migration operation.

    Args:
        catalog_id(str, optional): The ID of the catalog to migrate. Currently, this should be the Amazon Web Services account ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.catalog.import_status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.catalog.import_status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_catalog_import_status",
        op_kwargs={"CatalogId": catalog_id},
    )
