"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    accelerator_arn: str,
    port_ranges: List,
    protocol: str,
    idempotency_token: str,
    client_affinity: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of your accelerator.
        port_ranges(List): The list of port ranges to support for connections from clients to your accelerator.
        protocol(str): The protocol for connections from clients to your accelerator.
        client_affinity(str, optional): Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint. AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is NONE, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.  If you want a given client to always be routed to the same endpoint, set client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value. The default value is NONE. Defaults to None.
        idempotency_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.listener.create(
                ctx,
                accelerator_arn=value,
                port_ranges=value,
                protocol=value,
                idempotency_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.listener.create accelerator_arn=value, port_ranges=value, protocol=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="create_listener",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "PortRanges": port_ranges,
            "Protocol": protocol,
            "ClientAffinity": client_affinity,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, listener_arn: str) -> None:
    r"""
    **Autogenerated function**

    Delete a listener from an accelerator.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.listener.delete(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.listener.delete listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="delete_listener",
        op_kwargs={"ListenerArn": listener_arn},
    )


async def describe(hub, ctx, listener_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe a listener.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.listener.describe(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.listener.describe listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_listener",
        op_kwargs={"ListenerArn": listener_arn},
    )


async def list_all(
    hub, ctx, accelerator_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the listeners for an accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.
        max_results(int, optional): The number of listener objects that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.listener.list_all(ctx, accelerator_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.listener.list_all accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_listeners",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    listener_arn: str,
    port_ranges: List = None,
    protocol: str = None,
    client_affinity: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a listener.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to update.
        port_ranges(List, optional): The updated list of port ranges for the connections from clients to the accelerator. Defaults to None.
        protocol(str, optional): The updated protocol for the connections from clients to the accelerator. Defaults to None.
        client_affinity(str, optional): Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint. AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is NONE, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.  If you want a given client to always be routed to the same endpoint, set client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value. The default value is NONE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.listener.update(ctx, listener_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.listener.update listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="update_listener",
        op_kwargs={
            "ListenerArn": listener_arn,
            "PortRanges": port_ranges,
            "Protocol": protocol,
            "ClientAffinity": client_affinity,
        },
    )
