"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    listener_arn: str,
    endpoint_group_region: str,
    idempotency_token: str,
    endpoint_configurations: List = None,
    traffic_dial_percentage: float = None,
    health_check_port: int = None,
    health_check_protocol: str = None,
    health_check_path: str = None,
    health_check_interval_seconds: int = None,
    threshold_count: int = None,
    port_overrides: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS Region. A resource must be valid and active when you add it as an endpoint.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        endpoint_group_region(str): The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.
        endpoint_configurations(List, optional): The list of endpoint objects. Defaults to None.
        traffic_dial_percentage(float, optional): The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener.  Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing. The default value is 100. Defaults to None.
        health_check_port(int, optional): The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list. Defaults to None.
        health_check_protocol(str, optional): The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP. Defaults to None.
        health_check_path(str, optional): If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/). Defaults to None.
        health_check_interval_seconds(int, optional): The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30. Defaults to None.
        threshold_count(int, optional): The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3. Defaults to None.
        idempotency_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.
        port_overrides(List, optional): Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints. For more information, see  Port overrides in the AWS Global Accelerator Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.endpoint_group.create(
                ctx, listener_arn=value, endpoint_group_region=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.endpoint_group.create listener_arn=value, endpoint_group_region=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="create_endpoint_group",
        op_kwargs={
            "ListenerArn": listener_arn,
            "EndpointGroupRegion": endpoint_group_region,
            "EndpointConfigurations": endpoint_configurations,
            "TrafficDialPercentage": traffic_dial_percentage,
            "HealthCheckPort": health_check_port,
            "HealthCheckProtocol": health_check_protocol,
            "HealthCheckPath": health_check_path,
            "HealthCheckIntervalSeconds": health_check_interval_seconds,
            "ThresholdCount": threshold_count,
            "IdempotencyToken": idempotency_token,
            "PortOverrides": port_overrides,
        },
    )


async def delete(hub, ctx, endpoint_group_arn: str) -> None:
    r"""
    **Autogenerated function**

    Delete an endpoint group from a listener.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.endpoint_group.delete(
                ctx, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.endpoint_group.delete endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="delete_endpoint_group",
        op_kwargs={"EndpointGroupArn": endpoint_group_arn},
    )


async def describe(hub, ctx, endpoint_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe an endpoint group.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.endpoint_group.describe(
                ctx, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.endpoint_group.describe endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_endpoint_group",
        op_kwargs={"EndpointGroupArn": endpoint_group_arn},
    )


async def list_all(
    hub, ctx, listener_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the endpoint groups that are associated with a listener.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener.
        max_results(int, optional): The number of endpoint group objects that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.endpoint_group.list_all(
                ctx, listener_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.endpoint_group.list_all listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_endpoint_groups",
        op_kwargs={
            "ListenerArn": listener_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    endpoint_group_arn: str,
    endpoint_configurations: List = None,
    traffic_dial_percentage: float = None,
    health_check_port: int = None,
    health_check_protocol: str = None,
    health_check_path: str = None,
    health_check_interval_seconds: int = None,
    threshold_count: int = None,
    port_overrides: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an endpoint group. A resource must be valid and active when you add it as an endpoint.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group.
        endpoint_configurations(List, optional): The list of endpoint objects. A resource must be valid and active when you add it as an endpoint. Defaults to None.
        traffic_dial_percentage(float, optional): The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener.  Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing. The default value is 100. Defaults to None.
        health_check_port(int, optional): The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list. Defaults to None.
        health_check_protocol(str, optional): The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP. Defaults to None.
        health_check_path(str, optional): If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/). Defaults to None.
        health_check_interval_seconds(int, optional): The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30. Defaults to None.
        threshold_count(int, optional): The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3. Defaults to None.
        port_overrides(List, optional): Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints. For more information, see  Port overrides in the AWS Global Accelerator Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.endpoint_group.update(
                ctx, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.endpoint_group.update endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="update_endpoint_group",
        op_kwargs={
            "EndpointGroupArn": endpoint_group_arn,
            "EndpointConfigurations": endpoint_configurations,
            "TrafficDialPercentage": traffic_dial_percentage,
            "HealthCheckPort": health_check_port,
            "HealthCheckProtocol": health_check_protocol,
            "HealthCheckPath": health_check_path,
            "HealthCheckIntervalSeconds": health_check_interval_seconds,
            "ThresholdCount": threshold_count,
            "PortOverrides": port_overrides,
        },
    )
