"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def allow(
    hub,
    ctx,
    endpoint_group_arn: str,
    endpoint_id: str,
    destination_addresses: List = None,
    destination_ports: List = None,
    allow_all_traffic_to_endpoint: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group. After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group.
        endpoint_id(str): An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
        destination_addresses(List, optional): A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.  DestinationAddresses is required if AllowAllTrafficToEndpoint is FALSE or is not specified. Defaults to None.
        destination_ports(List, optional): A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic. Defaults to None.
        allow_all_traffic_to_endpoint(bool, optional): Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic from a custom routing accelerator. The value is TRUE or FALSE.  When set to TRUE, all destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE. When set to FALSE (or not specified), you must specify a list of destination IP addresses that are allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group. The default value is FALSE. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.traffic.allow(
                ctx, endpoint_group_arn=value, endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.traffic.allow endpoint_group_arn=value, endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="allow_custom_routing_traffic",
        op_kwargs={
            "EndpointGroupArn": endpoint_group_arn,
            "EndpointId": endpoint_id,
            "DestinationAddresses": destination_addresses,
            "DestinationPorts": destination_ports,
            "AllowAllTrafficToEndpoint": allow_all_traffic_to_endpoint,
        },
    )


async def deny(
    hub,
    ctx,
    endpoint_group_arn: str,
    endpoint_id: str,
    destination_addresses: List = None,
    destination_ports: List = None,
    deny_all_traffic_to_endpoint: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group. After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group.
        endpoint_id(str): An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
        destination_addresses(List, optional): A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group. Defaults to None.
        destination_ports(List, optional): A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic. Defaults to None.
        deny_all_traffic_to_endpoint(bool, optional): Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint cannot receive traffic from a custom routing accelerator. The value is TRUE or FALSE.  When set to TRUE, no destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE. When set to FALSE (or not specified), you must specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group. The default value is FALSE. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.traffic.deny(
                ctx, endpoint_group_arn=value, endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.traffic.deny endpoint_group_arn=value, endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="deny_custom_routing_traffic",
        op_kwargs={
            "EndpointGroupArn": endpoint_group_arn,
            "EndpointId": endpoint_id,
            "DestinationAddresses": destination_addresses,
            "DestinationPorts": destination_ports,
            "DenyAllTrafficToEndpoint": deny_all_traffic_to_endpoint,
        },
    )
