"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    accelerator_arn: str,
    endpoint_group_arn: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.  If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator. The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.
        endpoint_group_arn(str, optional): The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for. Defaults to None.
        max_results(int, optional): The number of destination port mappings that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.port_mapping.init.list_all(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.port_mapping.init.list_all accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_custom_routing_port_mappings",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "EndpointGroupArn": endpoint_group_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
