"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, accelerator_arn: str, port_ranges: List, idempotency_token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
        port_ranges(List): The port range to support for connections from clients to your accelerator. Separately, you set port ranges for endpoints. For more information, see About endpoints for custom routing accelerators.
        idempotency_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.listener.create(
                ctx, accelerator_arn=value, port_ranges=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.listener.create accelerator_arn=value, port_ranges=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="create_custom_routing_listener",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "PortRanges": port_ranges,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, listener_arn: str) -> None:
    r"""
    **Autogenerated function**

    Delete a listener for a custom routing accelerator.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.listener.delete(
                ctx, listener_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.listener.delete listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="delete_custom_routing_listener",
        op_kwargs={"ListenerArn": listener_arn},
    )


async def describe(hub, ctx, listener_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    The description of a listener for a custom routing accelerator.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.listener.describe(
                ctx, listener_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.listener.describe listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_custom_routing_listener",
        op_kwargs={"ListenerArn": listener_arn},
    )


async def list_all(
    hub, ctx, accelerator_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the listeners for a custom routing accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator to list listeners for.
        max_results(int, optional): The number of listener objects that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.listener.list_all(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.listener.list_all accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_custom_routing_listeners",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, listener_arn: str, port_ranges: List) -> Dict:
    r"""
    **Autogenerated function**

    Update a listener for a custom routing accelerator.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to update.
        port_ranges(List): The updated port range to support for connections from clients to your accelerator. If you remove ports that are currently being used by a subnet endpoint, the call fails. Separately, you set port ranges for endpoints. For more information, see About endpoints for custom routing accelerators.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.listener.update(
                ctx, listener_arn=value, port_ranges=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.listener.update listener_arn=value, port_ranges=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="update_custom_routing_listener",
        op_kwargs={"ListenerArn": listener_arn, "PortRanges": port_ranges},
    )
