"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, endpoint_configurations: List, endpoint_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator. The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports.  Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException. By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the  AllowCustomRoutingTraffic operation.

    Args:
        endpoint_configurations(List): The list of endpoint objects to add to a custom routing accelerator.
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.init.add(
                ctx, endpoint_configurations=value, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.init.add endpoint_configurations=value, endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="add_custom_routing_endpoints",
        op_kwargs={
            "EndpointConfigurations": endpoint_configurations,
            "EndpointGroupArn": endpoint_group_arn,
        },
    )


async def remove(hub, ctx, endpoint_ids: List, endpoint_group_arn: str) -> None:
    r"""
    **Autogenerated function**

    Remove endpoints from a custom routing accelerator.

    Args:
        endpoint_ids(List): The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC) subnet IDs. .
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.init.remove(
                ctx, endpoint_ids=value, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.init.remove endpoint_ids=value, endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="remove_custom_routing_endpoints",
        op_kwargs={"EndpointIds": endpoint_ids, "EndpointGroupArn": endpoint_group_arn},
    )
