"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    listener_arn: str,
    endpoint_group_region: str,
    destination_configurations: List,
    idempotency_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one AWS Region.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
        endpoint_group_region(str): The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.
        destination_configurations(List): Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept client traffic on.
        idempotency_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.group.create(
                ctx,
                listener_arn=value,
                endpoint_group_region=value,
                destination_configurations=value,
                idempotency_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.group.create listener_arn=value, endpoint_group_region=value, destination_configurations=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="create_custom_routing_endpoint_group",
        op_kwargs={
            "ListenerArn": listener_arn,
            "EndpointGroupRegion": endpoint_group_region,
            "DestinationConfigurations": destination_configurations,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, endpoint_group_arn: str) -> None:
    r"""
    **Autogenerated function**

    Delete an endpoint group from a listener for a custom routing accelerator.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.group.delete(
                ctx, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.group.delete endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="delete_custom_routing_endpoint_group",
        op_kwargs={"EndpointGroupArn": endpoint_group_arn},
    )


async def describe(hub, ctx, endpoint_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe an endpoint group for a custom routing accelerator.

    Args:
        endpoint_group_arn(str): The Amazon Resource Name (ARN) of the endpoint group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.group.describe(
                ctx, endpoint_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.group.describe endpoint_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_custom_routing_endpoint_group",
        op_kwargs={"EndpointGroupArn": endpoint_group_arn},
    )


async def list_all(
    hub, ctx, listener_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the endpoint groups that are associated with a listener for a custom routing accelerator.

    Args:
        listener_arn(str): The Amazon Resource Name (ARN) of the listener to list endpoint groups for.
        max_results(int, optional): The number of endpoint group objects that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.endpoint.group.list_all(
                ctx, listener_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.endpoint.group.list_all listener_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_custom_routing_endpoint_groups",
        op_kwargs={
            "ListenerArn": listener_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
