"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    idempotency_token: str,
    ip_address_type: str = None,
    ip_addresses: List = None,
    enabled: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints. Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the  AllowCustomRoutingTraffic operation.  Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.

    Args:
        name(str): The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.
        ip_address_type(str, optional): The value for the address type must be IPv4. Defaults to None.
        ip_addresses(List, optional): Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix. Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool. Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses. For more information, see Bring your own IP addresses (BYOIP) in the AWS Global Accelerator Developer Guide. Defaults to None.
        enabled(bool, optional): Indicates whether an accelerator is enabled. The value is true or false. The default value is true.  If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted. Defaults to None.
        idempotency_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.
        tags(List, optional): Create tags for an accelerator. For more information, see Tagging in AWS Global Accelerator in the AWS Global Accelerator Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.init.create(
                ctx, name=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.init.create name=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="create_custom_routing_accelerator",
        op_kwargs={
            "Name": name,
            "IpAddressType": ip_address_type,
            "IpAddresses": ip_addresses,
            "Enabled": enabled,
            "IdempotencyToken": idempotency_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, accelerator_arn: str) -> None:
    r"""
    **Autogenerated function**

    Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set Enabled to false.  When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.  The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you delete an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see Authentication and Access Control in the AWS Global Accelerator Developer Guide.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the custom routing accelerator to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.init.delete(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.init.delete accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="delete_custom_routing_accelerator",
        op_kwargs={"AcceleratorArn": accelerator_arn},
    )


async def describe(hub, ctx, accelerator_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe a custom routing accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.init.describe(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.init.describe accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_custom_routing_accelerator",
        op_kwargs={"AcceleratorArn": accelerator_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List the custom routing accelerators for an AWS account.

    Args:
        max_results(int, optional): The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10. Defaults to None.
        next_token(str, optional): The token for the next set of results. You receive this token from a previous call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="list_custom_routing_accelerators",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    accelerator_arn: str,
    name: str = None,
    ip_address_type: str = None,
    enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a custom routing accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the accelerator to update.
        name(str, optional): The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen. Defaults to None.
        ip_address_type(str, optional): The value for the address type must be IPv4. Defaults to None.
        enabled(bool, optional): Indicates whether an accelerator is enabled. The value is true or false. The default value is true.  If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.init.update(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.init.update accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="update_custom_routing_accelerator",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "Name": name,
            "IpAddressType": ip_address_type,
            "Enabled": enabled,
        },
    )
