"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, accelerator_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe the attributes of a custom routing accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.attribute.describe_all(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.attribute.describe_all accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="describe_custom_routing_accelerator_attributes",
        op_kwargs={"AcceleratorArn": accelerator_arn},
    )


async def update_multiple(
    hub,
    ctx,
    accelerator_arn: str,
    flow_logs_enabled: bool = None,
    flow_logs_s3_bucket: str = None,
    flow_logs_s3_prefix: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update the attributes for a custom routing accelerator.

    Args:
        accelerator_arn(str): The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
        flow_logs_enabled(bool, optional): Update whether flow logs are enabled. The default value is false. If the value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified. For more information, see Flow Logs in the AWS Global Accelerator Developer Guide. Defaults to None.
        flow_logs_s3_bucket(str, optional): The name of the Amazon S3 bucket for the flow logs. Attribute is required if FlowLogsEnabled is true. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket. Defaults to None.
        flow_logs_s3_prefix(str, optional): Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if FlowLogsEnabled is true.  If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following: DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.globalaccelerator.custom_routing.accelerator.attribute.update_multiple(
                ctx, accelerator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.globalaccelerator.custom_routing.accelerator.attribute.update_multiple accelerator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="globalaccelerator",
        operation="update_custom_routing_accelerator_attributes",
        op_kwargs={
            "AcceleratorArn": accelerator_arn,
            "FlowLogsEnabled": flow_logs_enabled,
            "FlowLogsS3Bucket": flow_logs_s3_bucket,
            "FlowLogsS3Prefix": flow_logs_s3_prefix,
        },
    )
