"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def delete_multiple(hub, ctx, account_id: str, vault_name: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes the notification configuration set for a vault. The operation is eventually consistent; that is, it might take some time for Amazon S3 Glacier to completely disable the notifications and you might still receive some notifications for a short time after you send the delete request. An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM).  For conceptual information and underlying REST API, see Configuring Vault Notifications in Amazon S3 Glacier and Delete Vault Notification Configuration  in the Amazon S3 Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID. .
        vault_name(str): The name of the vault.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.notification.delete_multiple(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.notification.delete_multiple account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="delete_vault_notifications",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )


async def get_all(hub, ctx, account_id: str, vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation retrieves the notification-configuration subresource of the specified vault. For information about setting a notification configuration on a vault, see SetVaultNotifications. If a notification configuration for a vault is not set, the operation returns a 404 Not Found error. For more information about vault notifications, see Configuring Vault Notifications in Amazon S3 Glacier.  An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM). For conceptual information and underlying REST API, see Configuring Vault Notifications in Amazon S3 Glacier and Get Vault Notification Configuration  in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.notification.get_all(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.notification.get_all account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="get_vault_notifications",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )


async def set_(
    hub, ctx, account_id: str, vault_name: str, vault_notification_config: Dict = None
) -> None:
    r"""
    **Autogenerated function**

    This operation configures notifications that will be sent when specific events happen to a vault. By default, you don't get any notifications. To configure vault notifications, send a PUT request to the notification-configuration subresource of the vault. The request should include a JSON document that provides an Amazon SNS topic and specific events for which you want Amazon S3 Glacier to send notifications to the topic. Amazon SNS topics must grant permission to the vault to be allowed to publish notifications to the topic. You can configure a vault to publish a notification for the following vault events:    ArchiveRetrievalCompleted This event occurs when a job that was initiated for an archive retrieval is completed (InitiateJob). The status of the completed job can be "Succeeded" or "Failed". The notification sent to the SNS topic is the same output as returned from DescribeJob.     InventoryRetrievalCompleted This event occurs when a job that was initiated for an inventory retrieval is completed (InitiateJob). The status of the completed job can be "Succeeded" or "Failed". The notification sent to the SNS topic is the same output as returned from DescribeJob.    An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM). For conceptual information and underlying REST API, see Configuring Vault Notifications in Amazon S3 Glacier and Set Vault Notification Configuration  in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.
        vault_notification_config(Dict, optional): Provides options for specifying notification configuration. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.notification.set(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.notification.set account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="set_vault_notifications",
        op_kwargs={
            "accountId": account_id,
            "vaultName": vault_name,
            "vaultNotificationConfig": vault_notification_config,
        },
    )
