"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, account_id: str, vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation creates a new vault with the specified name. The name of the vault must be unique within a region for an AWS account. You can create up to 1,000 vaults per account. If you need to create more vaults, contact Amazon S3 Glacier. You must use the following guidelines when naming a vault.   Names can be between 1 and 255 characters long.   Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).   This operation is idempotent. An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM).  For conceptual information and underlying REST API, see Creating a Vault in Amazon Glacier and Create Vault  in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.init.create(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.init.create account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="create_vault",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )


async def delete(hub, ctx, account_id: str, vault_name: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes a vault. Amazon S3 Glacier will delete a vault only if there are no archives in the vault as of the last inventory and there have been no writes to the vault since the last inventory. If either of these conditions is not satisfied, the vault deletion fails (that is, the vault is not removed) and Amazon S3 Glacier returns an error. You can use DescribeVault to return the number of archives in a vault, and you can use Initiate a Job (POST jobs) to initiate a new inventory retrieval for a vault. The inventory contains the archive IDs you use to delete archives using Delete Archive (DELETE archive). This operation is idempotent. An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM).  For conceptual information and underlying REST API, see Deleting a Vault in Amazon Glacier and Delete Vault  in the Amazon S3 Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.init.delete(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.init.delete account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="delete_vault",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )


async def describe(hub, ctx, account_id: str, vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about a vault, including the vault's Amazon Resource Name (ARN), the date the vault was created, the number of archives it contains, and the total size of all the archives in the vault. The number of archives and their total size are as of the last inventory generation. This means that if you add or remove an archive from a vault, and then immediately use Describe Vault, the change in contents will not be immediately reflected. If you want to retrieve the latest inventory of the vault, use InitiateJob. Amazon S3 Glacier generates vault inventories approximately daily. For more information, see Downloading a Vault Inventory in Amazon S3 Glacier.  An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM). For conceptual information and underlying REST API, see Retrieving Vault Metadata in Amazon S3 Glacier and Describe Vault  in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID. .
        vault_name(str): The name of the vault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.init.describe(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.init.describe account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="describe_vault",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )


async def list_all(
    hub, ctx, account_id: str, marker: str = None, limit: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists all vaults owned by the calling user's account. The list returned in the response is ASCII-sorted by vault name. By default, this operation returns up to 10 items. If there are more vaults to list, the response marker field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new List Vaults request; otherwise, the marker field is null. To return a list of vaults that begins at a specific vault, set the marker request parameter to the vault ARN you obtained from a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying the limit parameter in the request.  An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM). For conceptual information and underlying REST API, see Retrieving Vault Metadata in Amazon S3 Glacier and List Vaults  in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens ('-') in the ID.
        marker(str, optional): A string used for pagination. The marker specifies the vault ARN after which the listing of vaults should begin. Defaults to None.
        limit(str, optional): The maximum number of vaults to be returned. The default limit is 10. The number of vaults returned might be fewer than the specified limit, but the number of returned vaults never exceeds the limit. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.vault.init.list_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.vault.init.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="list_vaults",
        op_kwargs={"accountId": account_id, "marker": marker, "limit": limit},
    )
