"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, account_id: str, vault_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists all the tags attached to a vault. The operation returns an empty map if there are no tags. For more information about tags, see Tagging Amazon S3 Glacier Resources.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.tags.for_vault.list(
                ctx, account_id=value, vault_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.tags.for_vault.list account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="list_tags_for_vault",
        op_kwargs={"accountId": account_id, "vaultName": vault_name},
    )
