"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists the provisioned capacity units for the specified AWS account.

    Args:
        account_id(str): The AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, don't include any hyphens ('-') in the ID. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.provisioned_capacity.list(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.provisioned_capacity.list account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="list_provisioned_capacity",
        op_kwargs={"accountId": account_id},
    )


async def purchase(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation purchases a provisioned capacity unit for an AWS account.

    Args:
        account_id(str): The AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, don't include any hyphens ('-') in the ID. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.provisioned_capacity.purchase(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.provisioned_capacity.purchase account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="purchase_provisioned_capacity",
        op_kwargs={"accountId": account_id},
    )
