"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    account_id: str,
    vault_name: str,
    upload_id: str,
    marker: str = None,
    limit: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make this request at any time during an in-progress multipart upload before you complete the upload (see CompleteMultipartUpload. List Parts returns an error for completed uploads. The list returned in the List Parts response is sorted by part range.  The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the response. You should always check the response for a marker at which to continue the list; if there are no more items the marker is null. To return a list of parts that begins at a specific part, set the marker request parameter to the value you obtained from a previous List Parts request. You can also limit the number of parts returned in the response by specifying the limit parameter in the request.  An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM). For conceptual information and the underlying REST API, see Working with Archives in Amazon S3 Glacier and List Parts in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID. .
        vault_name(str): The name of the vault.
        upload_id(str): The upload ID of the multipart upload.
        marker(str, optional): An opaque string used for pagination. This value specifies the part at which the listing of parts should begin. Get the marker value from the response of a previous List Parts response. You need only include the marker if you are continuing the pagination of results started in a previous List Parts request. Defaults to None.
        limit(str, optional): The maximum number of parts to be returned. The default limit is 50. The number of parts returned might be fewer than the specified limit, but the number of returned parts never exceeds the limit. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.part.list_all(
                ctx, account_id=value, vault_name=value, upload_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.part.list_all account_id=value, vault_name=value, upload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="list_parts",
        op_kwargs={
            "accountId": account_id,
            "vaultName": vault_name,
            "uploadId": upload_id,
            "marker": marker,
            "limit": limit,
        },
    )
