"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    account_id: str,
    vault_name: str,
    limit: str = None,
    marker: str = None,
    statuscode: str = None,
    completed: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished. The List Job operation returns a list of these jobs sorted by job initiation time.  Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time after they have completed enables you to get a job output in the event you miss the job completion notification or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download an archive. After the job completes, you start to download the archive but encounter a network error. In this scenario, you can retry and download the archive while the job exists.  The List Jobs operation supports pagination. You should always check the response Marker field. If there are no more jobs to list, the Marker field is set to null. If there are more jobs to list, the Marker field is set to a non-null value, which you can use to continue the pagination of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the Marker value for that job that you obtained from a previous List Jobs request. You can set a maximum limit for the number of jobs returned in the response by specifying the limit parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but the number of returned jobs never exceeds the limit. Additionally, you can filter the jobs list returned by specifying the optional statuscode parameter or completed parameter, or both. Using the statuscode parameter, you can specify to return only jobs that match either the InProgress, Succeeded, or Failed status. Using the completed parameter, you can specify to return only jobs that were completed (true) or jobs that were not completed (false). For more information about using this operation, see the documentation for the underlying REST API List Jobs.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID. .
        vault_name(str): The name of the vault.
        limit(str, optional): The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be fewer than the specified limit, but the number of returned jobs never exceeds the limit. Defaults to None.
        marker(str, optional): An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin. Get the marker value from a previous List Jobs response. You only need to include the marker if you are continuing the pagination of results started in a previous List Jobs request. Defaults to None.
        statuscode(str, optional): The type of job status to return. You can specify the following values: InProgress, Succeeded, or Failed. Defaults to None.
        completed(str, optional): The state of the jobs to return. You can specify true or false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.jobs.list(ctx, account_id=value, vault_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.jobs.list account_id=value, vault_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="list_jobs",
        op_kwargs={
            "accountId": account_id,
            "vaultName": vault_name,
            "limit": limit,
            "marker": marker,
            "statuscode": statuscode,
            "completed": completed,
        },
    )
