"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, account_id: str, vault_name: str, archive_id: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes an archive from a vault. Subsequent requests to initiate a retrieval of this archive will fail. Archive retrievals that are in progress for this archive ID may or may not succeed according to the following scenarios:   If the archive retrieval job is actively preparing the data for download when Amazon S3 Glacier receives the delete archive request, the archival retrieval operation might fail.   If the archive retrieval job has successfully prepared the archive for download when Amazon S3 Glacier receives the delete archive request, you will be able to download the output.   This operation is idempotent. Attempting to delete an already-deleted archive does not result in an error. An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM).  For conceptual information and underlying REST API, see Deleting an Archive in Amazon Glacier and Delete Archive in the Amazon Glacier Developer Guide.

    Args:
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID.
        vault_name(str): The name of the vault.
        archive_id(str): The ID of the archive to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.archive.delete(
                ctx, account_id=value, vault_name=value, archive_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.archive.delete account_id=value, vault_name=value, archive_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="delete_archive",
        op_kwargs={
            "accountId": account_id,
            "vaultName": vault_name,
            "archiveId": archive_id,
        },
    )


async def upload(
    hub,
    ctx,
    vault_name: str,
    account_id: str,
    archive_description: str = None,
    checksum: str = None,
    body: bytes = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your data is durably persisted. Amazon S3 Glacier returns the archive ID in the x-amz-archive-id header of the response.  You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID, you can also index it and give it a friendly name to allow for better searching. You can also use the optional archive description field to specify how the archive is referred to in an external index of archives, such as you might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more information, see InitiateJob.  You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree hash, see Computing Checksums.  You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the archive description when you either retrieve the archive or get the vault inventory. For more information, see InitiateJob. Amazon Glacier does not interpret the description in any way. An archive description does not need to be unique. You cannot use the description to retrieve or sort the archive list.  Archives are immutable. After you upload an archive, you cannot edit the archive or its description. An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don't have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see Access Control Using AWS Identity and Access Management (IAM).  For conceptual information and underlying REST API, see Uploading an Archive in Amazon Glacier and Upload Archive in the Amazon Glacier Developer Guide.

    Args:
        vault_name(str): The name of the vault.
        account_id(str): The AccountId value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single '-' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens ('-') in the ID. .
        archive_description(str, optional): The optional description of the archive you are uploading. Defaults to None.
        checksum(str, optional): The SHA256 tree hash of the data being uploaded. Defaults to None.
        body(bytes, optional): The data to upload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glacier.archive.upload(ctx, vault_name=value, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glacier.archive.upload vault_name=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glacier",
        operation="upload_archive",
        op_kwargs={
            "vaultName": vault_name,
            "accountId": account_id,
            "archiveDescription": archive_description,
            "checksum": checksum,
            "body": body,
        },
    )
