"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def request(hub, ctx, build_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift's Amazon S3. This is done as part of the build creation process; see CreateBuild. To request new credentials, specify the build ID as returned with an initial CreateBuild request. If successful, a new set of credentials are returned, along with the S3 storage location associated with the build ID.  Learn more    Create a Build with Files in S3   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        build_id(str): A unique identifier for the build to get credentials for. You can use either the build ID or ARN value. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.upload_credential.request(ctx, build_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.upload_credential.request build_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="request_upload_credentials",
        op_kwargs={"BuildId": build_id},
    )
