"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str = None,
    version: str = None,
    storage_location: Dict = None,
    zip_file: bytes = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.  To create a new script record, specify a script name and provide the script file(s). The script files and all dependencies must be zipped into a single file. You can pull the zip file from either of these locations:    A locally available directory. Use the ZipFile parameter for this option.   An Amazon Simple Storage Service (Amazon S3) bucket under your AWS account. Use the StorageLocation parameter for this option. You'll need to have an Identity Access Management (IAM) role that allows the Amazon GameLift service to access your S3 bucket.    If the call is successful, a new script record is created with a unique script ID. If the script file is provided as a local file, the file is uploaded to an Amazon GameLift-owned S3 bucket and the script record's storage location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift accesses the file at this storage location as needed for deployment.  Learn more   Amazon GameLift Realtime Servers   Set Up a Role for Amazon GameLift Access   Related actions   CreateScript | ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task

    Args:
        name(str, optional): A descriptive label that is associated with a script. Script names do not need to be unique. You can use UpdateScript to change this value later. . Defaults to None.
        version(str, optional): Version information that is associated with a build or script. Version strings do not need to be unique. You can use UpdateScript to change this value later. . Defaults to None.
        storage_location(Dict, optional): The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the ObjectVersion parameter to specify an earlier version. . Defaults to None.
        zip_file(bytes, optional): A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB. When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: --zip-file fileb://myRealtimeScript.zip. Defaults to None.
        tags(List, optional): A list of labels to assign to the new script resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see  Tagging AWS Resources in the AWS General Reference. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.script.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.script.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_script",
        op_kwargs={
            "Name": name,
            "Version": version,
            "StorageLocation": storage_location,
            "ZipFile": zip_file,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, script_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded, they are also deleted (files stored in an S3 bucket are not deleted).  To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script record no longer exists, the instance will go into an error state and be unable to host game sessions.  Learn more   Amazon GameLift Realtime Servers   Related actions   CreateScript | ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task

    Args:
        script_id(str): A unique identifier for the Realtime script to delete. You can use either the script ID or ARN value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.script.delete(ctx, script_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.script.delete script_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_script",
        op_kwargs={"ScriptId": script_id},
    )


async def describe(hub, ctx, script_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves properties for a Realtime script.  To request a script record, specify the script ID. If successful, an object containing the script properties is returned.  Learn more   Amazon GameLift Realtime Servers   Related actions   CreateScript | ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task

    Args:
        script_id(str): A unique identifier for the Realtime script to retrieve properties for. You can use either the script ID or ARN value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.script.describe(ctx, script_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.script.describe script_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_script",
        op_kwargs={"ScriptId": script_id},
    )


async def list_all(hub, ctx, limit: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves script records for all Realtime scripts that are associated with the AWS account in use.   Learn more   Amazon GameLift Realtime Servers   Related actions   CreateScript | ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task

    Args:
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.script.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.script.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="list_scripts",
        op_kwargs={"Limit": limit, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    script_id: str,
    name: str = None,
    version: str = None,
    storage_location: Dict = None,
    zip_file: bytes = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates Realtime script metadata and content. To update script metadata, specify the script ID and provide updated name and/or version values.  To update script content, provide an updated zip file by pointing to either a local file or an Amazon S3 bucket location. You can use either method regardless of how the original script was uploaded. Use the Version parameter to track updates to the script. If the call is successful, the updated metadata is stored in the script record and a revised script is uploaded to the Amazon GameLift service. Once the script is updated and acquired by a fleet instance, the new version is used for all new game sessions.   Learn more   Amazon GameLift Realtime Servers   Related actions   CreateScript | ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task

    Args:
        script_id(str): A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
        name(str, optional): A descriptive label that is associated with a script. Script names do not need to be unique. Defaults to None.
        version(str, optional): Version information that is associated with a build or script. Version strings do not need to be unique. Defaults to None.
        storage_location(Dict, optional): The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the ObjectVersion parameter to specify an earlier version. . Defaults to None.
        zip_file(bytes, optional): A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB. When using the AWS CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: --zip-file fileb://myRealtimeScript.zip. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.script.update(ctx, script_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.script.update script_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_script",
        op_kwargs={
            "ScriptId": script_id,
            "Name": name,
            "Version": version,
            "StorageLocation": storage_location,
            "ZipFile": zip_file,
        },
    )
