"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a fleet's runtime configuration settings. The runtime configuration tells GameLift which server processes to run (and how) on each instance in the fleet. To get the runtime configuration that is currently in forces for a fleet, provide the fleet ID.  If successful, a RuntimeConfiguration object is returned for the requested fleet. If the requested fleet has been deleted, the result set is empty.  Learn more   Setting up GameLift fleets   Running multiple processes on a fleet   Related actions   ListFleets | DescribeEC2InstanceLimits | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetEvents | DescribeFleetLocationAttributes | DescribeFleetPortSettings | DescribeFleetUtilization | DescribeRuntimeConfiguration | DescribeScalingPolicies | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to get the runtime configuration for. You can use either the fleet ID or ARN value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.runtime_configuration.describe(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.runtime_configuration.describe fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_runtime_configuration",
        op_kwargs={"FleetId": fleet_id},
    )


async def update(hub, ctx, fleet_id: str, runtime_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates the current runtime configuration for the specified fleet, which tells GameLift how to launch server processes on all instances in the fleet. You can update a fleet's runtime configuration at any time after the fleet is created; it does not need to be in ACTIVE status. To update runtime configuration, specify the fleet ID and provide a RuntimeConfiguration with an updated set of server process configurations. If successful, the fleet's runtime configuration settings are updated. Each instance in the fleet regularly checks for and retrieves updated runtime configurations. Instances immediately begin complying with the new configuration by launching new server processes or not replacing existing processes when they shut down. Updating a fleet's runtime configuration never affects existing server processes.  Learn more   Setting up GameLift fleets   Related actions   CreateFleetLocations | UpdateFleetAttributes | UpdateFleetCapacity | UpdateFleetPortSettings | UpdateRuntimeConfiguration | StopFleetActions | StartFleetActions | PutScalingPolicy | DeleteFleet | DeleteFleetLocations | DeleteScalingPolicy | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.
        runtime_configuration(Dict): Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.runtime_configuration.update(
                ctx, fleet_id=value, runtime_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.runtime_configuration.update fleet_id=value, runtime_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_runtime_configuration",
        op_kwargs={"FleetId": fleet_id, "RuntimeConfiguration": runtime_configuration},
    )
