"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, game_session_id: str, player_id: str, player_data: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Reserves an open player slot in a game session for a player. New player sessions can be created in any game session with an open slot that is in ACTIVE status and has a player creation policy of ACCEPT_ALL. You can add a group of players to a game session with CreatePlayerSessions.  To create a player session, specify a game session ID, player ID, and optionally a set of player data.  If successful, a slot is reserved in the game session for the player and a new PlayerSession object is returned with a player session ID. The player references the player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the GameLift service. Player sessions cannot be updated.   Available in Amazon GameLift Local.   Related actions   CreatePlayerSession | CreatePlayerSessions | DescribePlayerSessions | StartGameSessionPlacement | DescribeGameSessionPlacement | All APIs by task

    Args:
        game_session_id(str): A unique identifier for the game session to add a player to.
        player_id(str): A unique identifier for a player. Player IDs are developer-defined.
        player_data(str, optional): Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.player_session.create(
                ctx, game_session_id=value, player_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.player_session.create game_session_id=value, player_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_player_session",
        op_kwargs={
            "GameSessionId": game_session_id,
            "PlayerId": player_id,
            "PlayerData": player_data,
        },
    )


async def create_multiple(
    hub, ctx, game_session_id: str, player_ids: List, player_data_map: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Reserves open slots in a game session for a group of players. New player sessions can be created in any game session with an open slot that is in ACTIVE status and has a player creation policy of ACCEPT_ALL. To add a single player to a game session, use CreatePlayerSession.  To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of player data for each player ID.  If successful, a slot is reserved in the game session for each player, and new PlayerSession objects are returned with player session IDs. Each player references their player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the GameLift service. Player sessions cannot be updated.  Available in Amazon GameLift Local.   Related actions   CreatePlayerSession | CreatePlayerSessions | DescribePlayerSessions | StartGameSessionPlacement | DescribeGameSessionPlacement | All APIs by task

    Args:
        game_session_id(str): A unique identifier for the game session to add players to.
        player_ids(List): List of unique identifiers for the players to be added.
        player_data_map(Dict, optional): Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the PlayerIds parameter are ignored. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.player_session.create_multiple(
                ctx, game_session_id=value, player_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.player_session.create_multiple game_session_id=value, player_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_player_sessions",
        op_kwargs={
            "GameSessionId": game_session_id,
            "PlayerIds": player_ids,
            "PlayerDataMap": player_data_map,
        },
    )


async def describe_all(
    hub,
    ctx,
    game_session_id: str = None,
    player_id: str = None,
    player_session_id: str = None,
    player_session_status_filter: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves properties for one or more player sessions.  This action can be used in the following ways:    To retrieve a specific player session, provide the player session ID only.   To retrieve all player sessions in a game session, provide the game session ID only.   To retrieve all player sessions for a specific player, provide a player ID only.   To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter this request by player session status. Use the pagination parameters to retrieve results as a set of sequential pages.  If successful, a PlayerSession object is returned for each session that matches the request.  Available in Amazon GameLift Local.   Related actions   CreatePlayerSession | CreatePlayerSessions | DescribePlayerSessions | StartGameSessionPlacement | DescribeGameSessionPlacement | All APIs by task

    Args:
        game_session_id(str, optional): A unique identifier for the game session to retrieve player sessions for. Defaults to None.
        player_id(str, optional): A unique identifier for a player to retrieve player sessions for. Defaults to None.
        player_session_id(str, optional): A unique identifier for a player session to retrieve. Defaults to None.
        player_session_status_filter(str, optional): Player session status to filter results on. Possible player session statuses include the following:    RESERVED -- The player session request has been received, but the player has not yet connected to the server process and/or been validated.     ACTIVE -- The player has been validated by the server process and is currently connected.    COMPLETED -- The player connection has been dropped.    TIMEDOUT -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).  . Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.player_session.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.player_session.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_player_sessions",
        op_kwargs={
            "GameSessionId": game_session_id,
            "PlayerId": player_id,
            "PlayerSessionId": player_session_id,
            "PlayerSessionStatusFilter": player_session_status_filter,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
