"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, ticket_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a successful match is made--connection information for the resulting new game session.  To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket object is returned for each requested ID that currently exists. This operation is not designed to be continually called to track matchmaking ticket status. This practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple Notification Service (SNS) to receive notifications, and provide the topic ARN in the matchmaking configuration. Continuously poling ticket status with DescribeMatchmaking should only be used for games in development with low matchmaking usage.   Learn more    Add FlexMatch to a game client    Set Up FlexMatch event notification   Related actions   StartMatchmaking | DescribeMatchmaking | StopMatchmaking | AcceptMatch | StartMatchBackfill | All APIs by task

    Args:
        ticket_ids(List): A unique identifier for a matchmaking ticket. You can include up to 10 ID values. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.init.describe(ctx, ticket_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.init.describe ticket_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_matchmaking",
        op_kwargs={"TicketIds": ticket_ids},
    )


async def start(
    hub, ctx, configuration_name: str, players: List, ticket_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that use GameLift managed hosting, this operation also triggers GameLift to find hosting resources and start a new game session for the new match. Each matchmaking request includes information on one or more players and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to build a match that includes all players in the request, placing them in the same team and finding additional players as needed to fill the match.  To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to be matched. You must also include any player attributes that are required by the matchmaking configuration's rule set. If successful, a matchmaking ticket is returned with status set to QUEUED.  Track matchmaking events to respond as needed and acquire game session connection information for successfully completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification Service (SNS), which is defined in the matchmaking configuration.  Learn more    Add FlexMatch to a game client    Set Up FlexMatch event notification    How GameLift FlexMatch works   Related actions   StartMatchmaking | DescribeMatchmaking | StopMatchmaking | AcceptMatch | StartMatchBackfill | All APIs by task

    Args:
        ticket_id(str, optional): A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate one in the form of a UUID. Use this identifier to track the matchmaking ticket status and retrieve match results. Defaults to None.
        configuration_name(str): Name of the matchmaking configuration to use for this request. Matchmaking configurations must exist in the same Region as this request. You can use either the configuration name or ARN value.
        players(List): Information on each player to be matched. This information must include a player ID, and may contain player attributes and latency data to be used in the matchmaking process. After a successful match, Player objects contain the name of the team the player is assigned to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.init.start(
                ctx, configuration_name=value, players=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.init.start configuration_name=value, players=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="start_matchmaking",
        op_kwargs={
            "TicketId": ticket_id,
            "ConfigurationName": configuration_name,
            "Players": players,
        },
    )


async def stop(hub, ctx, ticket_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a matchmaking ticket or match backfill ticket that is currently being processed. To stop the matchmaking operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed to CANCELLED. This call is also used to turn off automatic backfill for an individual game session. This is for game sessions that are created with a matchmaking configuration that has automatic backfill enabled. The ticket ID is included in the MatchmakerData of an updated game session object, which is provided to the game server.  If the operation is successful, the service sends back an empty JSON struct with the HTTP 200 response (not an empty HTTP body).   Learn more    Add FlexMatch to a game client   Related actions   StartMatchmaking | DescribeMatchmaking | StopMatchmaking | AcceptMatch | StartMatchBackfill | All APIs by task

    Args:
        ticket_id(str): A unique identifier for a matchmaking ticket.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.init.stop(ctx, ticket_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.init.stop ticket_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="stop_matchmaking",
        op_kwargs={"TicketId": ticket_id},
    )
