"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    request_timeout_seconds: int,
    acceptance_required: bool,
    rule_set_name: str,
    description: str = None,
    game_session_queue_arns: List = None,
    acceptance_timeout_seconds: int = None,
    notification_target: str = None,
    additional_player_count: int = None,
    custom_event_data: str = None,
    game_properties: List = None,
    game_session_data: str = None,
    backfill_mode: str = None,
    flex_match_mode: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're also using GameLift hosting, it defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests (StartMatchmaking or StartMatchBackfill) identify the matchmaking configuration to use and provide player attributes consistent with that configuration.  To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode (with or without GameLift hosting); a rule set that specifies how to evaluate players and find acceptable matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When using FlexMatch with GameLift hosting, you also need to identify the game session queue to use when starting a game session for the match. In addition, you must set up an Amazon Simple Notification Service (SNS) topic to receive matchmaking notifications. Provide the topic ARN in the matchmaking configuration. An alternative method, continuously polling ticket status with DescribeMatchmaking, is only suitable for games in development with low matchmaking usage.  Learn more    Design a FlexMatch matchmaker    Set up FlexMatch event notification   Related actions   CreateMatchmakingConfiguration | DescribeMatchmakingConfigurations | UpdateMatchmakingConfiguration | DeleteMatchmakingConfiguration | CreateMatchmakingRuleSet | DescribeMatchmakingRuleSets | ValidateMatchmakingRuleSet | DeleteMatchmakingRuleSet | All APIs by task

    Args:
        name(str): A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.
        description(str, optional): A human-readable description of the matchmaking configuration. . Defaults to None.
        game_session_queue_arns(List, optional): The Amazon Resource Name (ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If FlexMatchMode is set to STANDALONE, do not set this parameter. . Defaults to None.
        request_timeout_seconds(int): The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.
        acceptance_timeout_seconds(int, optional): The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. . Defaults to None.
        acceptance_required(bool): A flag that determines whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status REQUIRES_ACCEPTANCE to indicate when a completed potential match is waiting for player acceptance. .
        rule_set_name(str): A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
        notification_target(str, optional): An SNS topic ARN that is set up to receive matchmaking notifications. See  Setting up notifications for matchmaking for more information. Defaults to None.
        additional_player_count(int, optional): The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        custom_event_data(str, optional): Information to be added to all events related to this matchmaking configuration. . Defaults to None.
        game_properties(List, optional): A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). This information is added to the new GameSession object that is created for a successful match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        game_session_data(str, optional): A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). This information is added to the new GameSession object that is created for a successful match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        backfill_mode(str, optional): The method used to backfill game sessions that are created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a StartMatchBackfill request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in  Backfill Existing Games with FlexMatch. Automatic backfill is not available when FlexMatchMode is set to STANDALONE. Defaults to None.
        flex_match_mode(str, optional): Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.     STANDALONE - FlexMatch forms matches and returns match information, including players and team assignments, in a  MatchmakingSucceeded event.    WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match.   . Defaults to None.
        tags(List, optional): A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see  Tagging AWS Resources in the AWS General Reference. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.configuration.create(
                ctx,
                name=value,
                request_timeout_seconds=value,
                acceptance_required=value,
                rule_set_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.configuration.create name=value, request_timeout_seconds=value, acceptance_required=value, rule_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_matchmaking_configuration",
        op_kwargs={
            "Name": name,
            "Description": description,
            "GameSessionQueueArns": game_session_queue_arns,
            "RequestTimeoutSeconds": request_timeout_seconds,
            "AcceptanceTimeoutSeconds": acceptance_timeout_seconds,
            "AcceptanceRequired": acceptance_required,
            "RuleSetName": rule_set_name,
            "NotificationTarget": notification_target,
            "AdditionalPlayerCount": additional_player_count,
            "CustomEventData": custom_event_data,
            "GameProperties": game_properties,
            "GameSessionData": game_session_data,
            "BackfillMode": backfill_mode,
            "FlexMatchMode": flex_match_mode,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.  Related actions   CreateMatchmakingConfiguration | DescribeMatchmakingConfigurations | UpdateMatchmakingConfiguration | DeleteMatchmakingConfiguration | CreateMatchmakingRuleSet | DescribeMatchmakingRuleSets | ValidateMatchmakingRuleSet | DeleteMatchmakingRuleSet | All APIs by task

    Args:
        name(str): A unique identifier for the matchmaking configuration. You can use either the configuration name or ARN value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.configuration.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.configuration.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_matchmaking_configuration",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub,
    ctx,
    names: List = None,
    rule_set_name: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of FlexMatch matchmaking configurations.  This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.  If successful, a configuration is returned for each requested name. When specifying a list of names, only configurations that currently exist are returned.   Learn more    Setting up FlexMatch matchmakers   Related actions   CreateMatchmakingConfiguration | DescribeMatchmakingConfigurations | UpdateMatchmakingConfiguration | DeleteMatchmakingConfiguration | CreateMatchmakingRuleSet | DescribeMatchmakingRuleSets | ValidateMatchmakingRuleSet | DeleteMatchmakingRuleSet | All APIs by task

    Args:
        names(List, optional): A unique identifier for the matchmaking configuration(s) to retrieve. You can use either the configuration name or ARN value. To request all existing configurations, leave this parameter empty. Defaults to None.
        rule_set_name(str, optional): A unique identifier for the matchmaking rule set. You can use either the rule set name or ARN value. Use this parameter to retrieve all matchmaking configurations that use this rule set. Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This parameter is limited to 10. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_matchmaking_configurations",
        op_kwargs={
            "Names": names,
            "RuleSetName": rule_set_name,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    description: str = None,
    game_session_queue_arns: List = None,
    request_timeout_seconds: int = None,
    acceptance_timeout_seconds: int = None,
    acceptance_required: bool = None,
    rule_set_name: str = None,
    notification_target: str = None,
    additional_player_count: int = None,
    custom_event_data: str = None,
    game_properties: List = None,
    game_session_data: str = None,
    backfill_mode: str = None,
    flex_match_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates settings for a FlexMatch matchmaking configuration. These changes affect all matches and game sessions that are created after the update. To update settings, specify the configuration name to be updated and provide the new settings.   Learn more    Design a FlexMatch matchmaker   Related actions   CreateMatchmakingConfiguration | DescribeMatchmakingConfigurations | UpdateMatchmakingConfiguration | DeleteMatchmakingConfiguration | CreateMatchmakingRuleSet | DescribeMatchmakingRuleSets | ValidateMatchmakingRuleSet | DeleteMatchmakingRuleSet | All APIs by task

    Args:
        name(str): A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. .
        description(str, optional): A descriptive label that is associated with matchmaking configuration. Defaults to None.
        game_session_queue_arns(List, optional): The Amazon Resource Name (ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If FlexMatchMode is set to STANDALONE, do not set this parameter. Defaults to None.
        request_timeout_seconds(int, optional): The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed. Defaults to None.
        acceptance_timeout_seconds(int, optional): The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. Defaults to None.
        acceptance_required(bool, optional): A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status REQUIRES_ACCEPTANCE to indicate when a completed potential match is waiting for player acceptance. . Defaults to None.
        rule_set_name(str, optional): A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region. Defaults to None.
        notification_target(str, optional): An SNS topic ARN that is set up to receive matchmaking notifications. See  Setting up notifications for matchmaking for more information. Defaults to None.
        additional_player_count(int, optional): The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        custom_event_data(str, optional): Information to add to all events related to the matchmaking configuration. . Defaults to None.
        game_properties(List, optional): A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). This information is added to the new GameSession object that is created for a successful match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        game_session_data(str, optional): A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). This information is added to the new GameSession object that is created for a successful match. This parameter is not used if FlexMatchMode is set to STANDALONE. Defaults to None.
        backfill_mode(str, optional): The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a StartMatchBackfill request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in Backfill Existing Games with FlexMatch. Automatic backfill is not available when FlexMatchMode is set to STANDALONE. Defaults to None.
        flex_match_mode(str, optional): Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.     STANDALONE - FlexMatch forms matches and returns match information, including players and team assignments, in a  MatchmakingSucceeded event.    WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.matchmaking.configuration.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.matchmaking.configuration.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_matchmaking_configuration",
        op_kwargs={
            "Name": name,
            "Description": description,
            "GameSessionQueueArns": game_session_queue_arns,
            "RequestTimeoutSeconds": request_timeout_seconds,
            "AcceptanceTimeoutSeconds": acceptance_timeout_seconds,
            "AcceptanceRequired": acceptance_required,
            "RuleSetName": rule_set_name,
            "NotificationTarget": notification_target,
            "AdditionalPlayerCount": additional_player_count,
            "CustomEventData": custom_event_data,
            "GameProperties": game_properties,
            "GameSessionData": game_session_data,
            "BackfillMode": backfill_mode,
            "FlexMatchMode": flex_match_mode,
        },
    )
