"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, ticket_id: str, player_ids: List, acceptance_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may require player acceptance; if so, then matches built with that configuration cannot be completed unless all players accept the proposed match within a specified time limit.  When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status REQUIRES_ACCEPTANCE. This is a trigger for your game to get acceptance from all players in the ticket. Acceptances are only valid for tickets when they are in this status; all other acceptances result in an error. To register acceptance, specify the ticket ID, a response, and one or more players. Once all players have registered acceptance, the matchmaking tickets advance to status PLACING, where a new game session is created for the match.  If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed match is dropped. The matchmaking tickets are then handled in one of two ways: For tickets where one or more players rejected the match, the ticket status is returned to SEARCHING to find a new match. For tickets where one or more players failed to respond, the ticket status is set to CANCELLED, and processing is terminated. A new matchmaking request for these players can be submitted as needed.   Learn more    Add FlexMatch to a game client    FlexMatch events (reference)  Related actions   StartMatchmaking | DescribeMatchmaking | StopMatchmaking | AcceptMatch | StartMatchBackfill | All APIs by task

    Args:
        ticket_id(str): A unique identifier for a matchmaking ticket. The ticket must be in status REQUIRES_ACCEPTANCE; otherwise this request will fail.
        player_ids(List): A unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.
        acceptance_type(str): Player response to the proposed match.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.match.init.accept(
                ctx, ticket_id=value, player_ids=value, acceptance_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.match.init.accept ticket_id=value, player_ids=value, acceptance_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="accept_match",
        op_kwargs={
            "TicketId": ticket_id,
            "PlayerIds": player_ids,
            "AcceptanceType": acceptance_type,
        },
    )
